param(
  [string[]]$Langs = @('pt','es','fr','it','de','zh','ja','ko','ar'),
  [string]$Pivot = 'en'
)

$ErrorActionPreference = 'Stop'

$here = Split-Path -Parent $MyInvocation.MyCommand.Path
Set-Location -LiteralPath $here

function Install-Pair([string]$from, [string]$to) {
  Write-Host ("[argos] instalando {0}->{1}" -f $from,$to)
  python .\argos_setup.py --from $from --to $to
}

Write-Host "[argos] Pivot: $Pivot" -ForegroundColor Cyan
Write-Host "[argos] Idiomas: $($Langs -join ', ')" -ForegroundColor Cyan

foreach ($l in $Langs) {
  $l = $l.Trim().ToLower()
  if (-not $l) { continue }
  if ($l -eq $Pivot) { continue }

  # Para ter N:N via pivot, precisa dos dois sentidos.
  Install-Pair -from $l -to $Pivot
  Install-Pair -from $Pivot -to $l
}

Write-Host "[argos] OK. Verifique em: http://127.0.0.1:5100/health" -ForegroundColor Green
