# aprender – Servidor de Tradução (Local)

Este servidor é **independente** e fica dentro de `aprender/translate_server`.

Ele faz duas coisas:
- Serve os arquivos do `aprender` (incluindo `microfonestt.html`).
- Expõe `POST /api/translate` e repassa para um tradutor local (LibreTranslate via Docker).

## 1) Tradutor local (SEM Docker) – Argos Translate (Python)

Pré-requisito: Python 3 instalado.

Na pasta `aprender/translate_server`:

```powershell
cd "C:\Users\hepte\OneDrive\Documentos\Flash_Card_Navegador_112025\aprender\translate_server"
python -m pip install -r requirements.txt
```

Se no Windows Server você vir erro do tipo `WinError 1114` / `c10.dll` ao subir o `argos_service.py`, é porque o `pip` instalou `argostranslate` **1.10+** (que pode puxar `spacy/torch`). A solução mais simples é **voltar para < 1.10** (o `requirements.txt` já está fixado assim). Para corrigir um ambiente já instalado:

```powershell
cd "C:\xampp\htdocs\hepsistemas\aprender\translate_server"
.\.venv\Scripts\python -m pip uninstall -y argostranslate spacy thinc torch stanza
.\.venv\Scripts\python -m pip install -r requirements.txt
```

Se mesmo assim ainda aparecer `WinError 1114` (DLL init) ao fazer `import torch`, normalmente falta o **Microsoft Visual C++ Redistributable 2015-2022 (x64)** no Windows Server.

Instalação silenciosa (PowerShell):

```powershell
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$url = "https://aka.ms/vs/17/release/vc_redist.x64.exe"
$exe = "$env:TEMP\vc_redist.x64.exe"
Invoke-WebRequest -Uri $url -OutFile $exe -UseBasicParsing
Start-Process -FilePath $exe -ArgumentList "/install","/quiet","/norestart" -Wait
```

### (Recomendado no servidor) Usar venv (`.venv`)

Se o `python argos_service.py` der erro de runtime (ex.: `No module named 'encodings'`), crie um ambiente virtual e rode tudo por ele:

```powershell
cd "C:\xampp\htdocs\hepsistemas\aprender\translate_server"
& "C:\Program Files\Python311\python.exe" -m venv .venv
\.\.venv\Scripts\python -m pip install -r requirements.txt
```

Depois use:

```powershell
\.\.venv\Scripts\python argos_service.py
```

Instale o(s) modelo(s).

Observação: alguns pares (ex.: **pt -> it**) podem não existir direto no Argos.
Neste caso usamos **pivot via inglês (en)** automaticamente.

Exemplo para **pt -> it** (pivot via en):

```powershell
python argos_setup.py --from pt --to en
python argos_setup.py --from en --to it
```

Inicie o serviço local do Argos:

```powershell
python argos_service.py
```

Ele sobe em `http://127.0.0.1:5100/translate`.

Importante:
- O servidor Node (`/api/translate`) agora faz **instalação sob demanda** dos modelos Argos.
- Ou seja: o primeiro uso de um idioma novo pode demorar (download do modelo).
- Nem todos os idiomas do mundo têm modelo Argos; quando não existir, ele tenta fallbacks.

## Offline (todas as combinações N:N)

Para traduzir **qualquer idioma -> qualquer idioma** sem internet, este projeto usa pivot em inglês:

`source -> en -> target`

Para isso funcionar 100% offline, você precisa ter instalado, para cada idioma `lang`:

- `lang -> en`
- `en -> lang`

Com internet (apenas uma vez), rode o script que pré-instala os pares mais comuns do combobox:

```powershell
cd "C:\xampp\htdocs\hepsistemas\aprender\translate_server"
python -m pip install -r requirements.txt
./preinstalar_todos_pivot_en.ps1
```

Depois disso, traduzir não precisa mais de internet (desde que você não adicione novos idiomas).

## 2) Rodar o servidor do aprender (Node)

```powershell
cd "C:\Users\hepte\OneDrive\Documentos\Flash_Card_Navegador_112025\aprender\translate_server"
npm install
npm start
```

Abra:
- `http://localhost:3100/microfonestt.html`

## (Opcional) Tradutor local COM Docker – LibreTranslate

Se você tiver Docker Desktop, pode usar o `docker-compose.yml`:

```powershell
docker compose up -d
```

Ele sobe em `http://localhost:5000/translate`.

## Variáveis de ambiente

- `PORT` (padrão: `3100`)
- `ARGOS_URL` (padrão: `http://127.0.0.1:5100/translate`)
- `LIBRE_URL` (padrão: `http://localhost:5000/translate`)
- `PYTHON_EXE` (opcional): caminho do Python a ser usado para instalar modelos Argos sob demanda (ex.: `.venv`)

Exemplo PowerShell:

```powershell
$env:PORT = "3100"
$env:ARGOS_URL = "http://127.0.0.1:5100/translate"
$env:LIBRE_URL = "http://localhost:5000/translate"
$env:PYTHON_EXE = "C:\\xampp\\htdocs\\hepsistemas\\aprender\\translate_server\\.venv\\Scripts\\python.exe"
npm start
```
