// Este arquivo guarda o JavaScript (a parte que dá “vida” à página)

// Pega o botão pelo id "btn" para conseguir usar ele no código
const btn = document.getElementById('btn');

// Pega a caixa de saída pelo id "saida" para conseguir trocar o texto dela
const saida = document.getElementById('saida');

// Pega o título pelo id "titulo" para conseguir mudar a cor dele
const titulo = document.getElementById('titulo');

// Pega o botão de cor pelo id "btnCor" para conseguir ouvir o clique
const btnCor = document.getElementById('btnCor');

// Diz: quando a pessoa clicar no botão, execute a função abaixo
btn.addEventListener('click', () => {
	// Cria uma data/hora com o momento exato do clique
	const agora = new Date();

	// Coloca uma mensagem na tela mostrando a data e a hora do clique
	saida.textContent = 'Você clicou em: ' + agora.toLocaleString('pt-BR');
});

// Quando a pessoa clicar no botão de cor, troque a cor do título
btnCor.addEventListener('click', () => {
	// Se o título estiver vermelho, trocamos para azul
	if (titulo.classList.contains('titulo-vermelho')) {
		titulo.classList.remove('titulo-vermelho');
		titulo.classList.add('titulo-azul');
		return;
	}

	// Se o título estiver azul, trocamos para vermelho
	if (titulo.classList.contains('titulo-azul')) {
		titulo.classList.remove('titulo-azul');
		titulo.classList.add('titulo-vermelho');
		return;
	}

	// Se não tiver cor ainda, começamos deixando vermelho
	titulo.classList.add('titulo-vermelho');
});
