@echo off
setlocal EnableExtensions

REM Auto-elevacao (Admin)
net session >nul 2>nul
if errorlevel 1 (
  powershell -NoProfile -ExecutionPolicy Bypass -Command "Start-Process -FilePath '%~f0' -Verb RunAs"
  exit /b 0
)

REM Para os servidores do projeto "aprender" matando os processos que estiverem
REM ouvindo nas portas:
REM - 3100 (Node)
REM - 5100 (Argos Python)

echo.
echo [aprender] Parando servidores (portas 3100 e 5100)...
echo.

set "SNAP=%TEMP%\aprender_netstat_tcp.txt"
call :SNAPSHOT

call :KILL_PORT 3100
call :KILL_PORT 5100

echo.
echo [aprender] Verificando...
call :SNAPSHOT
call :CHECK_PORT 3100
call :CHECK_PORT 5100
del /q "%SNAP%" >nul 2>nul
echo.
echo [aprender] Pronto.
echo.

REM Fecha as janelas abertas dos servidores (se existirem) via PID gravado no iniciar_servidor.bat
echo [aprender] Fechando janelas dos servidores...
set "PIDFILE=%~dp0server_pids.txt"
if exist "%PIDFILE%" (
  for /f "usebackq delims=" %%P in ("%PIDFILE%") do (
    echo - Fechando janela PID %%P
    taskkill /F /T /PID %%P >nul 2>nul
  )
  del /q "%PIDFILE%" >nul 2>nul
) else (
  echo - Nenhum PID registrado (ok^).
)

REM Fallback: fecha por titulo (ex.: "Administrator: Argos 5100")
powershell -NoProfile -ExecutionPolicy Bypass -Command "$titles=@('Argos 5100','Node 3100'); foreach($t in $titles){ $procs=@(Get-Process -ErrorAction SilentlyContinue | Where-Object { $_.MainWindowTitle -and $_.MainWindowTitle -like ('*'+$t+'*') }); foreach($p in $procs){ try{ Stop-Process -Id $p.Id -Force -ErrorAction SilentlyContinue }catch{} } }" >nul 2>nul

REM Fallback 2: taskkill por titulo com wildcard (pega CMD/PowerShell/consoles com prefixos)
taskkill /F /T /FI "WINDOWTITLE eq *Argos 5100*" >nul 2>nul
taskkill /F /T /FI "WINDOWTITLE eq *Node 3100*" >nul 2>nul

REM Fallback 3 (mais forte): fecha por CommandLine (nao depende de titulo/PIDfile)
for /f "usebackq delims=" %%P in (`powershell -NoProfile -ExecutionPolicy Bypass -Command "$ErrorActionPreference='SilentlyContinue'; $rx='argos_service\.py|server\.js|Argos 5100|Node 3100'; Get-WmiObject Win32_Process | Where-Object { $_.CommandLine -and ($_.CommandLine -match $rx) -and ($_.Name -match '^(powershell|pwsh|cmd)\.exe$') } | ForEach-Object { $_.ProcessId }"`) do (
  echo %%P | findstr /R "^[0-9][0-9]*$" >nul 2>nul
  if not errorlevel 1 (
    echo - Fechando janela PID %%P (CommandLine^)
    taskkill /F /T /PID %%P >nul 2>nul
  )
)
echo.

pause
endlocal
exit /b 0

:KILL_PORT
set "PORT=%~1"
set "FOUND=0"

for /f "tokens=5" %%P in ('findstr /R /C:":%PORT% .*LISTENING" "%SNAP%"') do (
  set "FOUND=1"
  echo - Matando PID %%P (porta %PORT%^)
  taskkill /PID %%P /F >nul 2>nul
)

if "%FOUND%"=="0" (
  echo - Nenhum processo ouvindo na porta %PORT%.
)
exit /b 0

:CHECK_PORT
set "PORT=%~1"
findstr /R /C:":%PORT% .*LISTENING" "%SNAP%" >nul 2>nul
if errorlevel 1 (
  echo - Porta %PORT% OK (livre^).
) else (
  echo - ATENCAO: ainda existe processo ouvindo na porta %PORT%.
)
exit /b 0

:SNAPSHOT
netstat -ano -p tcp > "%SNAP%" 2>nul
exit /b 0

