// Arquivo: langspri.js
// Objetivo: centralizar a lista de idiomas que você vai usar no projeto.
//
// Por que este arquivo existe?
// - Você quer ter UMA lista única de idiomas.
// - O combobox de idiomas (no microfonestt.html) é populado a partir daqui.
// - STT (SpeechRecognition) e TTS (SpeechSynthesis) usam códigos de idioma no padrão BCP-47.
//
// O que é BCP-47?
// - É o formato de idioma usado na Web, por exemplo:
//   - "pt-BR" (português do Brasil)
//   - "pt-PT" (português de Portugal)
//   - "fr-FR" (francês da França)
//   - "en-US" (inglês dos EUA)
//
// IMPORTANTE:
// - As chaves (fr, it, ptbr...) são "apelidos" internos do seu projeto.
// - O valor em LANGS_BCP é o que vai para `recognition.lang` (STT) e `utterance.lang` (TTS).

// window.LANGS: nomes amigáveis, para mostrar na UI.
// Ex.: window.LANGS.fr -> "Francês"
window.LANGS = {
	fr: 'Francês',
	it: 'Italiano',
	es: 'Espanhol',
	en: 'Inglês (EUA)',
	ptbr: 'Português (BR)',
	ptpt: 'Português (PT)',
	de: 'Alemão',
	zh: 'Chinês',
	ko: 'Coreano',
	ja: 'Japonês',
	ar: 'Árabe'
};

// window.LANGS_BCP: códigos BCP-47 correspondentes aos idiomas.
// Ex.: window.LANGS_BCP.fr -> "fr-FR"
window.LANGS_BCP = {
	fr: 'fr-FR',
	it: 'it-IT',
	es: 'es-ES',
	en: 'en-US',
	ptbr: 'pt-BR',
	ptpt: 'pt-PT',
	de: 'de-DE',
	zh: 'zh-CN',
	ko: 'ko-KR',
	ja: 'ja-JP',
	ar: 'ar-SA'
};
  