@echo off
setlocal EnableExtensions

REM Inicia os servidores do projeto "aprender" abrindo DUAS janelas do PowerShell:
REM - Argos (Python) na porta 5100
REM - Node/Express na porta 3100
REM
REM IMPORTANTE: execute o ARQUIVO .bat (nao cole o conteudo no CMD).

REM Auto-elevacao (Admin)
net session >nul 2>nul
if errorlevel 1 (
  powershell -NoProfile -ExecutionPolicy Bypass -Command "Start-Process -FilePath '%~f0' -Verb RunAs"
  exit /b 0
)

set "ROOT=%~dp0"
set "SRV=%ROOT%translate_server"

echo.
echo [aprender] Iniciando servidores...
echo translate_server (tentativa): %SRV%
echo.

if exist "%SRV%\argos_service.py" if exist "%SRV%\server.js" goto :SRV_OK

echo Nao achei automaticamente a pasta translate_server.
echo Cole o caminho COMPLETO onde estao os arquivos:
echo - argos_service.py
echo - server.js
echo Exemplo: C:\xampp\htdocs\hepsistemas\aprender\translate_server
echo.
set /p "SRV=translate_server= "
set "SRV=%SRV:"=%"

if "%SRV%"=="" goto :ERR_SRV
if not exist "%SRV%\argos_service.py" goto :ERR_SRV
if not exist "%SRV%\server.js" goto :ERR_SRV

:SRV_OK
echo.
echo [aprender] Usando translate_server: %SRV%
echo.

REM Python: usa .venv se existir, senao usa python do PATH
set "PYEXE=%SRV%\.venv\Scripts\python.exe"
if exist "%PYEXE%" goto :PY_OK
set "PYEXE=python"
where python >nul 2>nul
if errorlevel 1 goto :ERR_PY

:PY_OK

REM Node
where node >nul 2>nul
if errorlevel 1 goto :ERR_NODE

REM Abre os dois servidores em janelas do PowerShell (ficam abertas)
set "PIDFILE=%ROOT%server_pids.txt"
del /q "%PIDFILE%" >nul 2>nul

REM Inicia e registra o PID da janela do PowerShell (para fechar depois)
powershell -NoProfile -ExecutionPolicy Bypass -Command "$srv='%SRV%'; $py='%PYEXE%'; $pidFile='%PIDFILE%'; $cmd=\"`$Host.UI.RawUI.WindowTitle='Argos 5100'; Set-Location -LiteralPath '$srv'; & '$py' '.\\argos_service.py'\"; $p=Start-Process -FilePath 'powershell.exe' -ArgumentList @('-NoProfile','-ExecutionPolicy','Bypass','-NoExit','-Command',$cmd) -PassThru; Add-Content -Path $pidFile -Value $p.Id"
powershell -NoProfile -ExecutionPolicy Bypass -Command "$srv='%SRV%'; $pidFile='%PIDFILE%'; $cmd=\"`$Host.UI.RawUI.WindowTitle='Node 3100'; Set-Location -LiteralPath '$srv'; node '.\\server.js'\"; $p=Start-Process -FilePath 'powershell.exe' -ArgumentList @('-NoProfile','-ExecutionPolicy','Bypass','-NoExit','-Command',$cmd) -PassThru; Add-Content -Path $pidFile -Value $p.Id"

echo.
echo [aprender] Janelas abertas: Argos 5100 e Node 3100
echo Teste:
echo - http://127.0.0.1:5100/health
echo - http://127.0.0.1:3100/health
echo.
exit /b 0

:ERR_SRV
echo.
echo ERRO: pasta translate_server invalida: %SRV%
echo.
pause
exit /b 1

:ERR_PY
echo.
echo ERRO: Python nao encontrado no PATH e .venv inexistente.
echo Rode em: %SRV%
echo   python -m venv .venv
echo.
pause
exit /b 1

:ERR_NODE
echo.
echo ERRO: Node.js (node) nao encontrado no PATH.
echo.
pause
exit /b 1
